/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import noobanidus.mods.lootr.common.api.BuiltInLootrTypes;
import noobanidus.mods.lootr.common.api.ILootrType;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BaseLootrInfo(@Deprecated @Nullable LootrBlockType blockType, @Deprecated @Nullable ILootrInfo.LootrInfoType infoType, @Nullable ILootrType type, UUID uuid, String cachedKey, class_2338 pos, @Nullable class_2561 name, class_5321<class_1937> dimension, int containerSize, class_2371<class_1799> customInventory, class_5321<class_52> table, long seed) implements ILootrInfo
{
    public BaseLootrInfo(Optional<LootrBlockType> lootrBlockType, Optional<ILootrInfo.LootrInfoType> lootrInfoType, Optional<ILootrType> iLootrType, UUID uuid, String s, class_2338 pos, Optional<class_2561> component, class_5321<class_1937> levelResourceKey, Integer integer, Optional<class_2371<class_1799>> itemStacks, Optional<class_5321<class_52>> lootTableResourceKey, Optional<Long> aLong) {
        this(lootrBlockType.orElse(null), lootrInfoType.orElse(null), iLootrType.orElse(null), uuid, s, pos, component.orElse(null), levelResourceKey, (int)integer, (class_2371<class_1799>)((class_2371)itemStacks.orElse(null)), (class_5321<class_52>)((class_5321)lootTableResourceKey.orElse(null)), aLong.orElse(-1L));
    }

    public BaseLootrInfo(@Deprecated @Nullable LootrBlockType blockType, @Deprecated @Nullable ILootrInfo.LootrInfoType infoType, @Nullable ILootrType type, UUID uuid, String cachedKey, class_2338 pos, @Nullable class_2561 name, class_5321<class_1937> dimension, int containerSize, class_2371<class_1799> customInventory, class_5321<class_52> table, long seed) {
        this.blockType = blockType;
        this.infoType = infoType;
        this.type = BaseLootrInfo.resolveType(blockType, infoType, type);
        this.uuid = uuid;
        this.cachedKey = cachedKey;
        this.pos = pos;
        this.name = name;
        this.dimension = dimension;
        this.containerSize = containerSize;
        this.customInventory = customInventory;
        this.table = table;
        this.seed = seed;
    }

    public static BaseLootrInfo copy(ILootrInfo info) {
        return new BaseLootrInfo(info.getInfoBlockType(), info.getInfoType(), info.getInfoNewType(), info.getInfoUUID(), info.getInfoKey(), info.getInfoPos(), info.getInfoDisplayName(), info.getInfoDimension(), info.getInfoContainerSize(), info.getInfoReferenceInventory(), info.getInfoLootTable(), info.getInfoLootSeed());
    }

    public static ILootrType resolveType(@Nullable LootrBlockType blockType, @Nullable ILootrInfo.LootrInfoType infoType, @Nullable ILootrType type) {
        if (type != null) {
            return type;
        }
        if (blockType != null) {
            return BuiltInLootrTypes.fromLegacy(blockType);
        }
        if (infoType != null) {
            if (infoType == ILootrInfo.LootrInfoType.CONTAINER_BLOCK_ENTITY) {
                return BuiltInLootrTypes.CHEST;
            }
            if (infoType == ILootrInfo.LootrInfoType.CONTAINER_ENTITY) {
                return BuiltInLootrTypes.MINECART;
            }
        }
        return BuiltInLootrTypes.CHEST;
    }

    @Override
    @Deprecated
    @Nullable
    public LootrBlockType getInfoBlockType() {
        return this.blockType();
    }

    @Override
    @Deprecated
    @Nullable
    public ILootrInfo.LootrInfoType getInfoType() {
        return this.infoType();
    }

    @Override
    @Nullable
    public ILootrType getInfoNewType() {
        return this.type();
    }

    @Override
    @NotNull
    public UUID getInfoUUID() {
        return this.uuid();
    }

    @Override
    public String getInfoKey() {
        return this.cachedKey();
    }

    @Override
    public boolean hasBeenOpened() {
        return false;
    }

    @Override
    public boolean isPhysicallyOpen() {
        return false;
    }

    @Override
    @NotNull
    public class_2338 getInfoPos() {
        return this.pos();
    }

    @Override
    public class_2561 getInfoDisplayName() {
        if (this.name == null) {
            return class_2561.method_43473();
        }
        return this.name;
    }

    @Override
    @NotNull
    public class_5321<class_1937> getInfoDimension() {
        return this.dimension();
    }

    @Override
    public int getInfoContainerSize() {
        return this.containerSize();
    }

    @Override
    @Nullable
    public class_2371<class_1799> getInfoReferenceInventory() {
        return this.customInventory();
    }

    @Override
    public boolean isInfoReferenceInventory() {
        return this.customInventory() != null && !this.customInventory().isEmpty();
    }

    @Override
    @Nullable
    public class_5321<class_52> getInfoLootTable() {
        return this.table();
    }

    @Override
    public long getInfoLootSeed() {
        return this.seed();
    }

    @Override
    public class_1937 getInfoLevel() {
        return this.getDefaultLevel();
    }
}

